import Tiny from './Tiny/tiny.js'

Tiny({
  selector: 'main',

  state: {
    count: 10,
    childCount: 5
  },

  increaseCount (event) {
    this.setState({
      count: this.state.count + 1
    })
  },

  increaseChildCount (event) {
    this.setState({
      childCount: this.state.childCount + 1
    })
  },

  template () {
    return `
      <div class="component parent-component flow">
        <h1>Parent Counter</h1>
        <p>Count: ${this.state.count}</p>
        <button tiny-listener="[click, increaseCount]">Increase count by 1</button>

        <div class="half">
          <div class="component child-component flow">
            <h2>Child Counter</h2>
            <p>Count: ${this.state.childCount}</p>
            <button tiny-listener="[click, increaseChildCount]">Increase count by 1</button>
            <button tiny-listener="[click, increaseCount]">Increase parent count by 1</button>
          </div>
          <div class="component total-component flow text">
            <h2>Total Count</h2>
            <ul>
              <li>Parent Count: ${this.state.count}</li>
              <li>Child Count: ${this.state.childCount}</li>
              <li>Total Count: ${this.state.count + this.state.childCount}</li>
            </ul>
          </div>
        </div>
      </div>`
  }
})
