export default function Tiny (options) {
  const element = typeof options.selector === 'string'
    ? document.querySelector(options.selector)
    : options.selector

  function _render () {
    element.innerHTML = options.template()
  }

  options.setState = function (newState) {
    const entries = Object.entries(newState)
    for (const entry of entries) {
      options.state[entry[0]] = entry[1]
    }
    _render()
    _addEventListeners()
  }

  function _addEventListeners () {
    const listenerElements = document.querySelectorAll('[tiny-listener]')
    for (const listenerElement of listenerElements) {
      const attribute = listenerElement.getAttribute('tiny-listener')

      const listenerInfo = attribute
        .replace('[', '')
        .replace(']', '')
        .split(',')
        .map(l => l.trim())

      const [eventName, fn] = listenerInfo

      listenerElement.addEventListener(eventName, options[fn].bind(options))
    }
  }

  _render()
  _addEventListeners()
}
