// Resolve browser inconsistences when clicking on buttons
document.addEventListener('click', event => {
  if (event.target.matches('button')) {
    event.target.focus()
  }
})

const tabby = document.querySelector('.tabby')
const tabsList = tabby.querySelector('.tabs')
const tabs = [...tabby.querySelectorAll('.tab')]
const tabContents = [...tabby.querySelectorAll('.tab-content')]

tabsList.addEventListener('click', event => {
  const tab = event.target
  const target = tab.dataset.target
  const tabContent = tabby.querySelector('#' + target)

  // Selects a tab
  tabs.forEach(t => {
    t.classList.remove('is-selected')
    t.setAttribute('tabindex', '-1')
  })
  tab.classList.add('is-selected')
  tab.removeAttribute('tabindex')

  // Selects the corresponding tab content
  tabContents.forEach(c => c.classList.remove('is-selected'))
  tabContent.classList.add('is-selected')
})

tabsList.addEventListener('keydown', event => {
  const { key } = event
  if (key !== 'ArrowLeft' && key !== 'ArrowRight') return

  const index = tabs.findIndex(t => t.classList.contains('is-selected'))

  let targetTab
  if (key === 'ArrowLeft' && index !== 0) targetTab = tabs[index - 1]
  if (key === 'ArrowRight' && index !== tabs.length - 1) targetTab = tabs[index + 1]

  if (targetTab) {
    targetTab.click()
  }
})
