/* eslint-env browser */
import Tiny from '../Tiny/tiny.js'

export default Tiny({
  heroHTML () {
    const npcName = location.pathname.split('/heroes/')[1]
    const hero = this.props.heroes.find(h => h.npcHeroName === npcName)

    if (!hero) return ''

    return `<div class="single-column flow-2">
      <div class="clear site-title">
        <h1 data-hero-name>${hero.name}</h1>
        <img
          class="hero__img"
          data-hero-image
          src="${hero.image}"
        />
        <p data-hero-description></p>
      </div>

      <section hidden>
        <h2>Abilities</h2>
        <ul class="abilities flow" data-hero-abilities></ul>
      </section>
    </div>`
  },

  template () {
    return `
      <div class="hero-page">
        <header class="site-header">
          <div class="wrap">
            <div class="single-column">
              <a href="/">
                <img src="/images/logo.png" alt="Dota 2 Logo" />
              </a>
            </div>
          </div>
        </header>

        <main>
          <div class="wrap"> ${this.heroHTML()} </div>
        </main>
      </div>
    `
  }
})
