import Tiny from './Tiny/tiny.js'

const filters = [{
  name: 'attack-type',
  values: ['melee', 'ranged']
}, {
  name: 'primary-attribute',
  values: ['strength', 'agility', 'intelligence']
}, {
  name: 'role',
  values: ['carry', 'disabler', 'durable', 'escape', 'initiator', 'jungler', 'nuker', 'pusher', 'support']
}]

export default Tiny({
  template () {
    return `
      <!-- SVG for checkbox -->
      <svg height="1em" style="display: none">
        <symbol id="checkmark" viewBox="0 0 20 15">
          <title>Checkmark</title>
          <path
            d="M0 8l2-2 5 5L18 0l2 2L7 15z"
            fill="#bc4736"
            fill-rule="nonzero"
          />
        </symbol>
      </svg>

      <section class="filters"">
        <h2 id= "filters">Filters</h2>

        <fieldset class="flow">
          <legend>Filter by</legend>
          ${filters.map(filterType => {
            return `
              <div class="box filter-group" id="${filterType.name}">
                <p class="box__title">${filterType.name.replace('-', ' ')}</p>

                ${filterType.values.map(value => {
                  return `
                    <div class="checkbox">
                      <input
                        type="checkbox"
                        id="${value}"
                        name="${value}"
                      >
                      <label for="${value}">
                        <span class="checkbox__fakebox"></span>
                        <svg height="1em" viewBox="0 0 20 15">
                          <use xlink:href="#checkmark"></use>
                        </svg>
                        <span>${value.slice(0, 1).toUpperCase() + value.slice(1)}</span>
                      </label>
                    </div>
                  `
                }).join('')}
              </div>
            `
          }).join('')}
        </fieldset>
      </section>
    `
  }
})
