export default function Calculator () {
  const calculatorElement = createCalculator()
  const display = calculatorElement.querySelector('.calculator__display')
  const calculatorButtonsDiv = calculatorElement.querySelector('.calculator__keys')
  const operatorKeys = [...calculatorButtonsDiv.children]
    .filter(button => button.dataset.buttonType === 'operator')
  const clearButton = calculatorElement.querySelector('[data-key="clear"]')

  const calculator = {
    element: calculatorElement,

    get displayValue () { return display.textContent },
    set displayValue (value) { display.textContent = value },

    pressKey (key) {
      calculatorElement.querySelector(`[data-key="${key}"]`).click()
    },

    pressKeys (...keys) {
      keys.forEach(calculator.pressKey)
    },

    resetCalculator () {
      calculator.pressKeys('clear', 'clear')
    },

    handleNumberKeys (button) {
      const displayValue = calculator.displayValue
      const { previousButtonType } = calculatorElement.dataset
      const { key } = button.dataset

      if (displayValue === '0') {
        calculator.displayValue = key
      } else {
        calculator.displayValue = displayValue + key
      }

      if (previousButtonType === 'operator') {
        calculator.displayValue = key
      }

      if (previousButtonType === 'equal') {
        calculator.resetCalculator()
        calculator.displayValue = key
      }
    },

    handleClick (event) {
      if (!event.target.closest('button')) return
      const button = event.target
      const { buttonType } = button.dataset

      // Release operator pressed state
      operatorKeys.forEach(button => button.classList.remove('is-pressed'))

      if (buttonType !== 'clear') {
        clearButton.textContent = 'CE'
      }

      switch (buttonType) {
        // case 'clear': handleClearKey(calculator, button); break
        case 'number': calculator.handleNumberKeys(button); break
        // case 'decimal': handleDecimalKey(calculator); break
        // case 'operator': handleOperatorKeys(calculator, button); break
        // case 'equal': handleEqualKey(calculator); break
      }

      calculatorElement.dataset.previousButtonType = buttonType
    }
  }

  calculatorButtonsDiv.addEventListener('click', calculator.handleClick)

  return calculator
}

function createCalculator () {
  const calculator = document.createElement('div')
  calculator.classList.add('calculator')
  calculator.tabIndex = 0
  calculator.innerHTML = `
    <div class="calculator__display">0</div>
    <div class="calculator__keys">
      <button tabindex="-1" data-key="plus" data-button-type="operator"> + </button>
      <button tabindex="-1" data-key="minus" data-button-type="operator"> &minus; </button>
      <button tabindex="-1" data-key="times" data-button-type="operator"> &times; </button>
      <button tabindex="-1" data-key="divide" data-button-type="operator"> ÷ </button>
      <button tabindex="-1" data-key="1" data-button-type="number"> 1 </button>
      <button tabindex="-1" data-key="2" data-button-type="number"> 2 </button>
      <button tabindex="-1" data-key="3" data-button-type="number"> 3 </button>
      <button tabindex="-1" data-key="4" data-button-type="number"> 4 </button>
      <button tabindex="-1" data-key="5" data-button-type="number"> 5 </button>
      <button tabindex="-1" data-key="6" data-button-type="number"> 6 </button>
      <button tabindex="-1" data-key="7" data-button-type="number"> 7 </button>
      <button tabindex="-1" data-key="8" data-button-type="number"> 8 </button>
      <button tabindex="-1" data-key="9" data-button-type="number"> 9 </button>
      <button tabindex="-1" data-key="0" data-button-type="number"> 0 </button>
      <button tabindex="-1" data-key="decimal" data-button-type="decimal"> . </button>
      <button tabindex="-1" data-key="clear" data-button-type="clear"> AC </button>
      <button tabindex="-1" data-key="equal" data-button-type="equal"> = </button>
    </div>
  </div>
  `
  return calculator
}
